package info.kgeorgiy.java.helloModule;

public class PublicHello {
    public static void hello(final String message, Class<?> clazz) {
        System.out.format(
            "    %s: %s/%s%n", 
            message, 
            clazz.getModule().getName(),
            clazz.getName()
        );        
    }

    public static void main(final String... args) {
        System.out.println("Hello from " + PublicHello.class.getSimpleName());
        hello("RMI", java.rmi.Remote.class);
        hello("HttpServer", com.sun.net.httpserver.HttpServer.class);
    }
}
