package net;

import java.io.IOException;
import java.net.*;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
public enum HelloHttpClient {
    ;

    public static void main(final String... args) throws URISyntaxException, IOException, InterruptedException {
        final int port = HelloHttpServer.getPort(args);
        try (final HttpClient client = HttpClient.newBuilder()
                .version(HttpClient.Version.HTTP_2)
                .proxy(ProxySelector.of(new InetSocketAddress("proxy.ifmo.ru", 3128)))
                .followRedirects(HttpClient.Redirect.NORMAL)
                .cookieHandler(new CookieManager())
//                .authenticator(new Authenticator() { ... })
                .build()) {
            final HttpRequest request = HttpRequest.newBuilder()
                    .uri(new URI("http://localhost:" + port + "/hello"))
                    .version(HttpClient.Version.HTTP_2)
                    .header("User-Agent", "hello")
                    .timeout(Duration.ofSeconds(3))
                    .POST(HttpRequest.BodyPublishers.ofString("world", StandardCharsets.UTF_8))
                    .build();
            final HttpResponse<String> response = client.send(
                    request,
                    HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)
            );
            if (response.statusCode() == HttpURLConnection.HTTP_OK) {
                System.out.println(response.body());
            } else {
                System.err.format("Error: status code %d%n", response.statusCode());
            }
        }
    }
}
