import java.util.Arrays;

public class Classes {
    public static class Good implements Runnable {
        public Good() {
            log("Default constructor");
        }

        @Override
        public void run() {
            log("run()");
        }

        public static void main(final String... args) {
            log("main(" + Arrays.toString(args) + ")");
        }

        private static void log(final String message) {
            System.out.println("\t\t" + Good.class.getName() + ": " + message);
        }
    }

    public static abstract class Abstract implements Runnable {
        public Abstract() {
            log("Default constructor");
        }

        @Override
        public void run() {
            log("run()");
        }

        public static void main(final String... args) {
            log("main(" + Arrays.toString(args) + ")");
        }

        private static void log(final String message) {
            System.out.println("\t\t" + Abstract.class.getName() + ": " + message);
        }
    }

    public static class MethodThrows implements Runnable {
        @Override
        public void run() {
            log("run()");
            throw new RuntimeException("run");
        }

        public static void main(final String... args) {
            log("main(" + Arrays.toString(args) + ")");
            throw new RuntimeException("main");
        }

        private static void log(final String message) {
            System.out.println("\t\t" + MethodThrows.class.getName() + ": " + message);
        }
    }

    public class Bad {
    }

    public static class BadInit {
       static {
           if (true) {
               throw new RuntimeException("BadInit");
           }
       }
   }

   public static class NoMethods {
   }

   public static class Inaccessible {
       private Inaccessible() {
       }

       private static void main(final String... args) {
       }
   }
}