package swing.editor;

import javax.swing.*;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import java.awt.*;


public class AttributeFontSize implements CaretAttributeListener {
	private final JComboBox<Integer> comboBox = new JComboBox<>();

	@SuppressWarnings("unchecked")
	public AttributeFontSize(final JTextComponent text) {
		new CaretAttributeNotifier(text, StyleConstants.FontSize, this);

		comboBox.setRenderer(new BasicComboBoxRenderer() {
			public Component getListCellRendererComponent(
					final JList list,
					final Object value, final int index, final boolean isSelected,
					final boolean cellHasFocus
            ) {
				final int size = (Integer) value;
				super.getListCellRendererComponent(list, size, index, isSelected, cellHasFocus);
				setFont(new Font(comboBox.getFont().getFamily(), Font.PLAIN, size));
				return this;
			}
		});

		comboBox.addActionListener(actionEvent -> {
            final int size = comboBox.getItemAt(comboBox.getSelectedIndex());
            new StyledEditorKit.FontSizeAction("" + size, size).actionPerformed(actionEvent);
        });
		
		for (final int i : new Integer[]{8, 9, 10, 12, 14, 16, 20, 24, 28, 36, 48, 72}) {
			comboBox.addItem(i);
		}
		comboBox.setPrototypeDisplayValue(72);
		comboBox.setSelectedItem(12);
	}

	public JComponent getToolbarComponent() {
		return comboBox;
	}

	public void caretUpdate(final CaretEvent e, final Object value) {
		if (value != null) {
			comboBox.setSelectedItem(value);
		} else {
			comboBox.setSelectedItem(8);
		}
	}
}
