// Model: a[1]..a[n]
// Inv: n >= 0 && forall i=1..n: a[i] != null
// Let: immutable(k): forall i=1..k: a'[i] = a[i]
public class LinkedStack {
    private int size;
    private Node head;

    // Pre: element != null
    // Post: n' = n + 1 &&
    //       a'[n'] = element &&
    //       immutable(n)
    public void push(Object element) {
        assert element != null;

        size++;
        head = new Node(element, head);
    }

    // Pre: n > 0
    // Post: R = a[n] && n' = n - 1 && immutable(n')
    public Object pop() {
        assert size > 0;

        size--;
        Object result = head.value;
        head = head.next;
        return result;
    }

    // Pre: n > 0
    // Post: R = a[n] && n' = n && immutable(n)
    public Object peek() {
        assert size > 0;

        return head.value;
    }

    // Pre: true
    // Post: R = n && n' = n && immutable(n)
    public int size() {
        return size;
    }

    // Pre: true
    // Post: R = (n = 0) && n' = n && immutable(n)
    public boolean isEmpty() {
        return size == 0;
    }

    private class Node {
        private final Object value;
        private final Node next;

        public Node(Object value, Node next) {
            assert value != null;

            this.value = value;
            this.next = next;
        }
    }
}
