/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Boolean
implements Serializable {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class TYPE = Class.getPrimitiveClass("boolean");
    private boolean value;
    private static final long serialVersionUID = -3665804199014368530L;

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(String string) {
        this(Boolean.toBoolean(string));
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(String string) {
        return new Boolean(Boolean.toBoolean(string));
    }

    public String toString() {
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.value) {
            return 1231;
        }
        return 1237;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Boolean) {
            return this.value == (Boolean)object;
        }
        return false;
    }

    public static boolean getBoolean(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return Boolean.toBoolean(System.getProperty(string));
    }

    private static boolean toBoolean(String string) {
        return string != null && string.toLowerCase().equals("true");
    }
}

