/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Security;
import java.util.Properties;

public abstract class Provider
extends Properties {
    private String name;
    private String info;
    private double version;

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }

    Provider(String string) {
        this(string, 1.0, "no information available");
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    static Provider loadProvider(String string) {
        try {
            Class clazz = Class.forName(string);
            Object object = clazz.newInstance();
            if (object instanceof Provider) {
                return (Provider)object;
            }
        }
        catch (Exception exception) {
            Provider.debug("error loading provider " + string, exception);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.name) + " version " + this.version;
    }

    private static void debug(String string) {
        Security.debug(string);
    }

    private static void debug(String string, Throwable throwable) {
        Security.debug(string, throwable);
    }
}

